#version 140
#extension GL_EXT_gpu_shader4 : enable
// Raycast experiment 4Mod01.fsh by  alexijohansen 

//https://www.shadertoy.com/view/tdVcDV
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize


//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
//#define iMouse vec4(0.0,0.0, 0.0,0.0)
#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define CAMERATILT 82.5
#define CAMERAHEIGHT 1.0
#define STEPS 500
#define STEPSIZE 150.0

vec3 rotX(vec3 v, float a)
{
    v.y = (v.y * cos(a)) - (v.z * sin(a));
    v.z = (v.y * sin(a)) + (v.z * cos(a));

    return v;
} 
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (gl_FragCoord.xy/iResolution.xy - 0.5);

	float angle = (3.14/360.0)*CAMERATILT;
    
    vec3 p = vec3(0.0,CAMERAHEIGHT,fract(iTime*0.1));
    
    vec3 ray = rotX(vec3(uv.x,uv.y,1.0), angle) / STEPSIZE;
    
    float c = 0.0;
    
	for( int i = 0; i < STEPS; i++ )
    {
        float height = texture2D( iChannel0, vec2(p.x,p.z)).x;

        if (height > p.y)
        {
        	c = height;
            break;
        }
        
        p += ray;
    }

    gl_FragColor = vec4(c,c,c,1.0);
}